import React from 'react'
import Layout from "~/components/layout";
import {Box} from './styled';
import { Tabs , Button } from 'antd';
import type { TabsProps } from 'antd';
import Evaluate from './components/evaluate';

export default function index() {
  const onChange = (key: string) => {
    console.log(key);
  };
  
  const items: TabsProps['items'] = [
    {
      key: '1',
      label: `团队介绍`,
      children: `详情`,
    },
    {
      key: '2',
      label: `团队评价`,
      children: <Evaluate />,
    },
  ];

  return (
    <Layout>
      <Box>
        <div className='top'>
          <div className="top-image"></div>
          <div className='top-right'>
              <div className='right-top'>
                  <div className='title'>
                  农田测绘
                  </div>
                  <div className='detail'>
                    <div className='tab'>专业飞手</div>
                    <span className='content'>飞手需通过认证培训才可作业</span>
                  </div>
                  <div className='more'>
                  <div className='tab filst'>测绘场景榜第1名</div>
                    <div className='tab'>7x24小时服务</div>
                  </div>
              </div>
              <div className='right-bottom'>
                <div className='bottom-btn'>
                  <Button className='btn-left' size='small' type="primary">马上预约</Button>
                  <Button className='btn-right' size='small' type="primary">电话沟通</Button>
                </div>
              </div>
          </div>
        </div>
        <Tabs className='tabs' defaultActiveKey="1" items={items} onChange={onChange} />
      </Box>
    </Layout>
  )
}
